;CMD File for Jabu, don't copy anything
;===========================================================================
; Hyper Motions
;===========================================================================

[Command]
name = "unicorn_trampling"
command = B, DB, D, DF, F, x
time = 50

[Command]
name = "unicorn_spiral"
command = F, DF, D, DB, B, b
time = 50

[Command]
name = "unicorn_gallop"
command = F, DF, D, DB, B, c
time = 50
;===========================================================================
; Super Motions
;===========================================================================

[Command]
name = "double_kick0"
command = ~D, DF, F, a
time = 20

[Command]
name = "double_kick1"
command = ~D, DF, F, b
time = 20

[Command]
name = "double_kick2"
command = ~D, DF, F, c
time = 20

[Command]
name = "rotating_kick0"
command = ~D, DB, B, a
time = 20

[Command]
name = "rotating_kick1"
command = ~D, DB, B, b
time = 20

[Command]
name = "rotating_kick2"
command = ~D, DB, B, c
time = 20

[Command]
name = "pamonha_kick"
command = ~D, DF, F, a
time = 20

[Command]
name = "pamonha_kick"
command = ~D, DF, F, b
time = 20

[Command]
name = "pamonha_kick"
command = ~D, DF, F, c
time = 20

[Command]
name = "multi_kick0"
command = a,a,a,a
time = 50

[Command]
name = "multi_kick1"
command = b,b,b,b
time = 40

[Command]
name = "multi_kick2"
command = c,c,c,c
time = 30

[Command]
name = "throw"
command = x
time = 10

[Command]
name = "throw"
command = y
time = 10

[Command]
name = "throw"
command = z
time = 10

[Command]
name = "dropkick"
command = F, F, c
time = 20

;===========================================================================
; Special Motions
;===========================================================================

[Command]
name = "U"
command = U

;===========================================================================
; Double Tap Motions
;===========================================================================
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;===========================================================================
; 2/3 button combinations
;===========================================================================
[Command]
name = "recovery";Required (do not remove)
command = a+x
time = 1

;megablock
[Command]
name = "mega_block"
command = c+z
time = 50

Cosmo Explosion
[Command]
name = "cosmo"
command = x+y+z
time = 40
[Command]
name = "cosmo1"
command = /x
[Command]
name = "cosmo2"
command = /y
[Command]
name = "cosmo3"
command = /z


;===========================================================================
; Directions + Buttons
;===========================================================================
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;===========================================================================
; Singular Buttons
;===========================================================================
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;===========================================================================
; Hold Direction
;===========================================================================
[Command]
name = "DU"
command = D, U
time = 10

[Command]
name = "UF"
command = UF
time = 1

[Command]
name = "UB"
command = UB
time = 1

[Command]
name = "DUF"
command = D, UF
time = 10

[Command]
name = "DUB"
command = D, UB
time = 10

[Command]
name = "up"
command = U
time = 1
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;-----------------------
;superguard
[Command]
name = "holdback3"
command = /$B   
time = 50
;------------------------

;/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\|State Entry|/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
[Statedef -1]
;===========================================================================
; Hypers
;===========================================================================
;--------------------------------| Description |----------------------------
;Unicorn Rage
[state -1]
type = ChangeState
value = 3000
triggerall = var(59) != 1
triggerall = power >= 1000
triggerall = command = "unicorn_trampling"
trigger1 = statetype = S
trigger1 = ctrl = 1

;Unicorn Spirit
[state -1]
type = ChangeState
value = 3100
triggerall = var(59) != 1
triggerall = power >= 2000
triggerall = command = "unicorn_spiral"
trigger1 = statetype = S
trigger1 = ctrl = 1

;Unicorn Gallop
[state -1]
type = ChangeState
value = 3200
triggerall = var(59) != 1
triggerall = power >= 2000
triggerall = command = "unicorn_gallop"
trigger1 = statetype = S
trigger1 = ctrl = 1

;===========================================================================
; Supers
;===========================================================================

;Double Kick
[State -1]
type = ChangeState
value = 1000
triggerall = var(59) != 1
triggerall = command = "double_kick0"
trigger1 = statetype = S
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 1010
triggerall = var(59) != 1
triggerall = command = "double_kick1"
trigger1 = statetype = S
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 1020
triggerall = var(59) != 1
triggerall = command = "double_kick2"
trigger1 = statetype = S
trigger1 = ctrl = 1

;Rotating Kick
[State -1]
type = ChangeState
value = 1100
triggerall = var(59) != 1
triggerall = command = "rotating_kick0"
trigger1 = statetype = S
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 1110
triggerall = var(59) != 1
triggerall = command = "rotating_kick1"
trigger1 = statetype = S
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 1120
triggerall = var(59) != 1
triggerall = command = "rotating_kick2"
trigger1 = statetype = S
trigger1 = ctrl = 1

;Pamonha kick
[State -1]
type = ChangeState
value = 1200
triggerall = var(59) != 1
triggerall = command = "pamonha_kick"
trigger1 = statetype = A
trigger1 = ctrl = 1

;Multi kick
[State -1]
type = ChangeState
value = 1300
triggerall = var(59) != 1
triggerall = command = "multi_kick0"
trigger1 = statetype = S
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 1310
triggerall = var(59) != 1
triggerall = command = "multi_kick1"
trigger1 = statetype = S
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 1320
triggerall = var(59) != 1
triggerall = command = "multi_kick2"
trigger1 = statetype = S
trigger1 = ctrl = 1

;Throw
[State -1]
type = ChangeState
value = 1400
triggerall = command = "throw"
triggerall = statetype = S
triggerall = ctrl
trigger1 = command = "holdback"
trigger1 = p2bodydist X < 10
trigger1 = p2statetype = S

;Dropkick
[State -1]
type = ChangeState
value = 1500
triggerall = var(59) != 1
triggerall = command = "dropkick"
trigger1 = statetype != A
trigger1 = ctrl = 1


;===========================================================================
; Specials
;===========================================================================
;---------------------------------------------------------------------------

;Mega Block
[State -1, Mega Block]
type = ChangeState
value = 800
triggerall = var(59) != 1
triggerall = command = "mega_block"
triggerall = command = "holdback"
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------

;Cosmo Explosion
[State -1, Cosmo Explosion]
type = changestate
value = 900
triggerall = var(59) != 1
triggerall = command = "cosmo"
triggerall = power >= 500
trigger1 = statetype = S
trigger1 = ctrl = 1

;===========================================================================
; Basics
;===========================================================================
;---------------------------------------------------------------------------
; RunFwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = ((command = "FF") && (statetype = S) && (ctrl = 1))

;---------------------------------------------------------------------------
; Hop Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = ((command = "BB") && (statetype = S) && (ctrl = 1))

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 165
triggerall = var(59) != 1
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;------------------------------------------

;Stand A
[State -1, Standing Light Punch]
type = ChangeState
value = 200
triggerall = var(59) != 1
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;Stand B
[State -1, Standing Medium Punch]
type = ChangeState
value = 210
triggerall = var(59) != 1
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230
trigger2 = movecontact = 1

;Stand C
[State -1, Standing Strong Punch]
type = ChangeState
value = 220
triggerall = var(59) != 1
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 230
trigger2 = movecontact = 1
;----------------------------------

;Stand X
[State -1, Standing Light Kick]
type = ChangeState
value = 230
triggerall = var(59) != 1
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact = 1

;Standing Y
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = var(59) != 1
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 210
trigger2 = movecontact = 1

;Standing Z
[State -1, Standing Strong Kick]
type = ChangeState
value = 250
triggerall = var(59) != 1
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 210 || stateno = 240 || stateno = 220
trigger2 = movecontact = 1


;---------------------------------------------------------------------------
;Crouching A
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = var(59) != 1
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;Crouching B
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = var(59) != 1
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;Crouching C
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = var(59) != 1
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching X
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = var(59) != 1
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 400
trigger2 = movecontact = 1

;Crouching Y
[State -1, Crouching Medium Kick]
type = ChangeState
value = 440
triggerall = var(59) != 1
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 400
trigger2 = movecontact = 1

;Crouching Z
[State -1, Crouching Strong Kick]
type = ChangeState
value = 450
triggerall = var(59) != 1
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 210 || stateno = 400 || stateno = 430 || stateno = 410
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Jump A
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = var(59) != 1
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl = 1 
trigger2 = stateno = 640
trigger2 = movehit = 1

;Jump B
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = var(59) != 1
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl = 1 
trigger2 = stateno = 600
trigger2 = movecontact = 1


;Jump C
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = var(59) != 1
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630  || stateno = 640 
trigger2 = movecontact

;---------------------------------------------------------------------------
;Jump X
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = var(59) != 1
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 
trigger2 = movecontact

;Jump Y
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = var(59) != 1
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 
trigger2 = movecontact

;Jump Z
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = var(59) != 1
triggerall = command = "c"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 610 || stateno = 630
trigger2 = movecontact
